function [center, dimension] = pv_GetCenterPos(imagePath, findValue);

% load the image and convert it to grayscale
img = imread(imagePath);
imgGray = rgb2gray(img);

% find the section of the image that is white
if findValue < 0
  [y,x]= find(imgGray);
else
  [y,x]= find(imgGray >= findValue);
end

% calculate the size
width = max(x) - min(x);
height = max(y) - min(y);

% calculate the center
xCenter = round(min(x) + width / 2);
yCenter = round(min(y) + height / 2);
center = [xCenter yCenter];
dimension = [width, height];
