function lightVector = pv_GetLightDirection(centerHilight, centerSphere, radius);

% compute the x and y deltas
xDiff = centerHilight(1) - centerSphere(1);
yDiff = centerHilight(2) - centerSphere(2);

% compute the x and y diagonal
xyDiag = sqrt( xDiff * xDiff + yDiff * yDiff );

% compute the z location
z = sqrt( abs( radius * radius - xyDiag * xyDiag ) );

% normalize the vector which is the reflection of the light vector
lightRVector = [xDiff yDiff z];
vectorLength = sqrt( xDiff * xDiff + yDiff * yDiff + z * z );
lightRVector = lightRVector / vectorLength;

% compute the light vector
N = [0 0 1];
lightVector = 2 * dot(N, lightRVector) * N - lightRVector;
