function lightVectors = pv_GetLightVectors(imageMask, imageList);

% calculate the center and radius of the sphere
[centerSphere dimension] = pv_GetCenterPos(imageMask, -1);
radius = dimension(1) / 2;

% calculate the light vectors
for i=1:length(imageList(:,1))
  centerHilight = pv_GetCenterPos(deblank(imageList(i,:)), 255);
  lightVector = pv_GetLightDirection(centerHilight, centerSphere, radius);
  lightVectors(i,:) = lightVector;
end
